/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.issue;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class IssueFilterParameters {
    public static final String ISSUES = "issues";
    public static final String SEVERITIES = "severities";
    public static final String STATUSES = "statuses";
    public static final String RESOLUTIONS = "resolutions";
    public static final String RESOLVED = "resolved";
    public static final String COMPONENTS = "components";
    public static final String COMPONENT_KEYS = "componentKeys";
    public static final String COMPONENT_UUIDS = "componentUuids";
    public static final String COMPONENT_ROOTS = "componentRoots";
    public static final String COMPONENT_ROOT_UUIDS = "componentRootUuids";
    public static final String MODULE_UUIDS = "moduleUuids";
    public static final String PROJECTS = "projects";
    public static final String PROJECT_KEYS = "projectKeys";
    public static final String PROJECT_UUIDS = "projectUuids";
    public static final String DIRECTORIES = "directories";
    public static final String FILE_UUIDS = "fileUuids";
    public static final String ON_COMPONENT_ONLY = "onComponentOnly";
    public static final String RULES = "rules";
    public static final String ACTION_PLANS = "actionPlans";
    public static final String REPORTERS = "reporters";
    public static final String ASSIGNEES = "assignees";
    public static final String AUTHORS = "authors";
    public static final String LANGUAGES = "languages";
    public static final String TAGS = "tags";
    public static final String ASSIGNED = "assigned";
    public static final String PLANNED = "planned";
    public static final String HIDE_RULES = "hideRules";
    public static final String HIDE_COMMENTS = "hideComments";
    public static final String CREATED_AFTER = "createdAfter";
    public static final String CREATED_AT = "createdAt";
    public static final String CREATED_BEFORE = "createdBefore";
    public static final String CREATED_IN_LAST = "createdInLast";
    public static final String PAGE_SIZE = "pageSize";
    public static final String PAGE_INDEX = "pageIndex";
    public static final String SORT = "sort";
    public static final String ASC = "asc";
    public static final String ADDITIONAL_FIELDS = "additionalFields";
    public static final String FACET_MODE = "facetMode";
    public static final String FACET_MODE_COUNT = "count";
    public static final String FACET_MODE_DEBT = "debt";
    public static final String FACET_ASSIGNED_TO_ME = "assigned_to_me";
    public static final List<String> ALL = ImmutableList.of("issues", "severities", "statuses", "resolutions", "resolved", "components", "componentRoots", "rules", "actionPlans", "reporters", "tags", "assignees", new String[]{"languages", "assigned", "planned", "hideRules", "createdAt", "createdAfter", "createdBefore", "createdInLast", "componentUuids", "componentRootUuids", "facetMode", "projects", "projectUuids", "projectKeys", "componentKeys", "moduleUuids", "directories", "fileUuids", "authors", "hideComments", "pageSize", "pageIndex", "sort", "asc"});
    public static final List<String> ALL_WITHOUT_PAGINATION = ImmutableList.copyOf(Iterables.filter(ALL, new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            return !IssueFilterParameters.PAGE_INDEX.equals(input) && !IssueFilterParameters.PAGE_SIZE.equals(input);
        }
    }));

    private IssueFilterParameters() {
    }
}

